<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tour_routes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('site_id')->constrained()->onDelete('cascade');
            $table->string('description');
            $table->enum('assigned_to', ['all', 'specific'])->default('all');
            $table->text('special_instructions')->nullable();
            $table->integer('estimated_duration_minutes')->default(0);
            $table->integer('grace_period_minutes')->default(0);
            $table->enum('recurrence_type', ['weekly', 'monthly'])->default('weekly');
            $table->json('schedule_days')->nullable(); // For weekly: ['Monday', 'Tuesday'], for monthly: [1, 15]
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tour_routes');
    }
};
