<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('checkpoints', function (Blueprint $table) {
            $table->id();
            $table->foreignId('site_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->text('special_instructions')->nullable();
            $table->enum('scan_type', ['all', 'qr', 'nfc', 'manual'])->default('all');
            $table->enum('monitoring_option', ['regular', 'scan_regular', 'scan_interval'])->default('regular');
            $table->integer('scan_interval_minutes')->nullable();
            $table->string('checkpoint_type')->nullable();
            $table->string('checkpoint_id_code')->nullable()->unique();
            $table->boolean('allow_manual_scan')->default(false);
            $table->integer('grace_period_minutes')->default(0);
            $table->json('extra_scan_options')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('checkpoints');
    }
};
