<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('uniforms', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->cascadeOnDelete();
            $table->string('name'); // Uniform Type e.g., Shirt, Pant
            $table->string('code')->nullable(); // Uniform Code (Optional)
            $table->text('description')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        Schema::create('uniform_variants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('uniform_id')->constrained()->cascadeOnDelete();
            $table->string('size')->nullable(); // S, M, L, XL etc.
            $table->string('color')->nullable(); // Blue, Black etc.
            $table->integer('stock_quantity')->default(0);
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('uniform_variants');
        Schema::dropIfExists('uniforms');
    }
};
