<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->string('ownership')->default('Purchased'); // Purchased, Leased, Rented
            $table->string('status')->default('Active'); // Active, Inactive, Maintenance, Sold
            $table->string('vehicle_id')->unique(); // Internal reference code
            $table->string('make')->nullable();
            $table->string('model')->nullable();
            $table->string('year', 4)->nullable();
            $table->date('acquisition_date')->nullable();
            $table->string('license_plate')->nullable();
            $table->string('license_plate_country')->nullable();
            $table->string('license_plate_state')->nullable();
            $table->string('vin_number')->nullable()->unique();
            $table->string('color')->nullable();
            $table->text('comments')->nullable();
            $table->json('images')->nullable(); // Array of image paths
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vehicles');
    }
};
