<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('patroller_issue_tickets')) {
            Schema::create('patroller_issue_tickets', function (Blueprint $table) {
                $table->id();
                $table->foreignId('patroller_job_site_id')->constrained('patroller_job_sites')->onDelete('cascade');
                $table->foreignId('patroller_schedule_id')->constrained('patroller_schedules')->onDelete('cascade');
                $table->foreignId('site_id')->constrained('sites')->onDelete('cascade');
                $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');

                // Ticket data
                $table->string('ticket_number', 50);
                $table->text('description');
                $table->enum('status', ['good', 'bad'])->default('good');
                $table->json('images')->nullable();

                // Location data
                $table->decimal('latitude', 10, 8);
                $table->decimal('longitude', 11, 8);

                $table->timestamps();

                // Indexes
                $table->index('ticket_number');
                $table->index(['patroller_schedule_id', 'site_id']);
                $table->index('status');
                $table->index('created_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patroller_issue_tickets');
    }
};
