<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patroller_job_sites', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patroller_schedule_id')->constrained('patroller_schedules')->onDelete('cascade');
            $table->foreignId('site_id')->constrained('sites')->onDelete('cascade');
            $table->foreignId('employee_id')->constrained('employees')->onDelete('cascade');

            // Check-in data
            $table->timestamp('checked_in_at')->nullable();
            $table->decimal('checkin_latitude', 10, 8)->nullable();
            $table->decimal('checkin_longitude', 11, 8)->nullable();
            $table->json('checkin_images')->nullable();

            // Check-out data
            $table->timestamp('checked_out_at')->nullable();
            $table->decimal('checkout_latitude', 10, 8)->nullable();
            $table->decimal('checkout_longitude', 11, 8)->nullable();

            // Status
            $table->enum('status', ['pending', 'checked_in', 'checked_out'])->default('pending');

            $table->timestamps();

            // Indexes
            $table->index(['patroller_schedule_id', 'site_id']);
            $table->index('employee_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('patroller_job_sites');
    }
};
