<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('patroller_schedules', function (Blueprint $table) {
            if (!Schema::hasColumn('patroller_schedules', 'job_started_at')) {
                $table->timestamp('job_started_at')->nullable()->after('status');
            }
            if (!Schema::hasColumn('patroller_schedules', 'job_ended_at')) {
                $table->timestamp('job_ended_at')->nullable()->after('job_started_at');
            }
            if (!Schema::hasColumn('patroller_schedules', 'job_status')) {
                $table->enum('job_status', ['pending', 'in_progress', 'completed', 'auto_ended'])->default('pending')->after('job_ended_at');
                $table->index('job_status');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('patroller_schedules', function (Blueprint $table) {
            $table->dropIndex(['job_status']);
            $table->dropColumn(['job_started_at', 'job_ended_at', 'job_status']);
        });
    }
};
