<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employee_patroller_schedule', function (Blueprint $table) {
            $table->decimal('allowance', 10, 2)->default(0)->after('gas_rate');
            $table->decimal('other_expense', 10, 2)->default(0)->after('allowance');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employee_patroller_schedule', function (Blueprint $table) {
            $table->dropColumn(['allowance', 'other_expense']);
        });
    }
};
