<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('patroller_schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->string('duty_number')->unique();
            $table->date('scheduled_date');
            $table->foreignId('route_id')->constrained()->onDelete('cascade');
            $table->decimal('route_rate', 10, 2);
            $table->dateTime('from_time');
            $table->dateTime('to_time');
            $table->decimal('gas', 10, 2)->nullable();
            $table->decimal('allowance', 10, 2)->nullable();
            $table->decimal('other_expense', 10, 2)->nullable();
            $table->string('customer_reference')->nullable();
            $table->text('comments')->nullable();
            $table->enum('status', ['pending', 'active', 'upcoming', 'missed', 'completed'])->default('pending');
            $table->timestamps();

            $table->index(['company_id', 'scheduled_date']);
            $table->index(['status', 'scheduled_date']);
        });

        // Pivot table for patroller schedule employees
        Schema::create('employee_patroller_schedule', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patroller_schedule_id')->constrained()->onDelete('cascade');
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->json('wage_types')->nullable(); // Store wage type IDs as JSON
            $table->decimal('wage_rate', 10, 2)->nullable();
            $table->decimal('gas_rate', 10, 2)->nullable();
            $table->dateTime('actual_start_at')->nullable();
            $table->dateTime('actual_end_at')->nullable();
            $table->timestamps();

            $table->unique(['patroller_schedule_id', 'employee_id'], 'emp_patroller_schedule_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_patroller_schedule');
        Schema::dropIfExists('patroller_schedules');
    }
};
