<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('id_settings', function (Blueprint $table) {
            // Patroller ID
            $table->string('patroller_prefix')->nullable()->after('incident_next_number');
            $table->integer('patroller_next_number')->default(1)->after('patroller_prefix');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('id_settings', function (Blueprint $table) {
            $table->dropColumn(['patroller_prefix', 'patroller_next_number']);
        });
    }
};
