<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->string('licence_issuing_province')->nullable()->after('licence_issuing_province_id');
        });

        // Migrate existing data from the old ID-based column to the new text column
        DB::statement("
            UPDATE employees e
            LEFT JOIN states s ON e.licence_issuing_province_id = s.id
            SET e.licence_issuing_province = s.name
            WHERE e.licence_issuing_province_id IS NOT NULL
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn('licence_issuing_province');
        });
    }
};
