<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('incidents', function (Blueprint $table) {
            $table->foreignId('incident_parent_category_id')->nullable()->constrained('incident_parent_categories')->onDelete('set null');
            $table->foreignId('incident_category_id')->nullable()->constrained('incident_categories')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('incidents', function (Blueprint $table) {
            $table->dropForeign(['incident_parent_category_id']);
            $table->dropForeign(['incident_category_id']);
            $table->dropColumn(['incident_parent_category_id', 'incident_category_id']);
        });
    }
};
