<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('incident_categories', function (Blueprint $table) {
            $table->string('code')->nullable()->after('incident_parent_category_id');
            $table->renameColumn('name', 'description');
            $table->integer('priority_level')->default(5)->comment('1: High, 5: Low')->after('description');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('incident_categories', function (Blueprint $table) {
            $table->dropColumn('code');
            $table->dropColumn('priority_level');
            $table->renameColumn('description', 'name');
        });
    }
};
