<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->string('company_type')->nullable()->after('name');
            $table->string('ceo_name')->nullable()->after('contact_person');
            $table->string('ceo_email')->nullable()->after('ceo_name');
            $table->string('ceo_phone')->nullable()->after('ceo_email');
            $table->text('operational_areas')->nullable()->after('website');
        });

        Schema::create('company_branches', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->string('branch_code')->nullable();
            $table->text('address')->nullable();
            $table->string('contact_person')->nullable();
            $table->string('contact_phone')->nullable();
            $table->string('contact_email')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_branches');

        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn([
                'company_type',
                'ceo_name',
                'ceo_email',
                'ceo_phone',
                'operational_areas'
            ]);
        });
    }
};
