<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // 1. Schedule Templates (The Master Pattern container)
        Schema::create('schedule_templates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('site_id')->constrained()->cascadeOnDelete();
            $table->string('name')->default('Master Schedule');
            $table->integer('cycle_duration_days')->default(7); // 7, 14, 28
            $table->date('start_date')->nullable(); // Reference date for the cycle
            $table->json('settings')->nullable(); // For "Closed Days" configuration etc.
            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        // 2. Template Shifts (The items within the pattern)
        Schema::create('template_shifts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('schedule_template_id')->constrained()->cascadeOnDelete();
            $table->integer('day_offset'); // 1 to cycle_duration_days
            $table->time('start_time');
            $table->time('end_time');
            $table->foreignId('job_role_id')->constrained(); // "Position"
            $table->foreignId('employee_id')->nullable()->constrained(); // Pre-assigned guard (optional)
            $table->integer('break_duration_minutes')->default(0);
            $table->timestamps();
        });

        // 3. Employee Availabilities (For Phase 1 Prerequisites)
        Schema::create('employee_availabilities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->cascadeOnDelete();
            $table->unsignedTinyInteger('day_of_week'); // 0 (Sunday) to 6 (Saturday)
            $table->time('start_time');
            $table->time('end_time');
            $table->enum('status', ['available', 'preferred_not', 'unavailable'])->default('available');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_availabilities');
        Schema::dropIfExists('template_shifts');
        Schema::dropIfExists('schedule_templates');
    }
};
