<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('employee_experiences')) {
            Schema::create('employee_experiences', function (Blueprint $table) {
                $table->id();
                $table->foreignId('employee_id')->constrained()->onDelete('cascade');
                $table->string('company_name')->nullable();
                $table->string('proof_document')->nullable();
                $table->date('start_date')->nullable();
                $table->date('end_date')->nullable();
                $table->string('reason_for_leaving')->nullable();
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('employee_identifications')) {
            Schema::create('employee_identifications', function (Blueprint $table) {
                $table->id();
                $table->foreignId('employee_id')->constrained()->onDelete('cascade');
                $table->string('type')->nullable();
                $table->string('identification_number')->nullable();
                $table->date('expiry_date')->nullable();
                $table->string('file_path')->nullable();
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('employee_wage_type')) {
            Schema::create('employee_wage_type', function (Blueprint $table) {
                $table->foreignId('employee_id')->constrained()->onDelete('cascade');
                $table->foreignId('wage_type_id')->constrained()->onDelete('cascade');
                $table->decimal('rate', 10, 2)->nullable();
                $table->primary(['employee_id', 'wage_type_id']);
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('employee_wage_type');
        Schema::dropIfExists('employee_identifications');
        Schema::dropIfExists('employee_experiences');
    }
};
