<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lead_remarks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('lead_id')->constrained()->onDelete('cascade');
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Who created the remark

            $table->string('type')->default('note'); // note, call, email, meeting, survey_observation
            $table->string('disposition')->nullable(); // For calls: left_voicemail, connected, busy, etc.

            $table->text('content');
            $table->string('attachment_path')->nullable(); // For photos/docs

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lead_remarks');
    }
};
