<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leads', function (Blueprint $table) {
            $table->id();
            $table->foreignId('assigned_to')->nullable()->constrained('users')->onDelete('set null'); // Lead Owner

            // Core Contact Info
            $table->string('name');
            $table->string('company_name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('job_title')->nullable(); // e.g. CSO, Manager

            // Firmographics
            $table->string('industry')->nullable();
            $table->string('site_location')->nullable();
            $table->string('property_type')->nullable(); // Retail, Warehouse, etc.
            $table->integer('sq_footage')->nullable();

            // Security Scope
            $table->text('security_needs')->nullable(); // Description of guards/CCTV needed
            $table->string('current_provider')->nullable();

            // Workflow Status & Source
            $table->string('status')->default('new'); // new, contacted, matured, proposal, won, lost, disqualified
            $table->string('source')->default('manual'); // website, referral, linkedin, manual

            // Urgency & Scoring
            $table->date('contract_expiry_date')->nullable(); // When their current contract ends
            $table->boolean('incident_history')->default(false); // Has recent thefts/security issues?

            // Follow-up Management
            $table->date('next_follow_up_date')->nullable();
            $table->string('next_action')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leads');
    }
};
