<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quotation_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('quotation_id')->constrained()->onDelete('cascade');

            $table->string('type')->default('service'); // 'service' or 'product'
            $table->string('description'); // e.g., "Event Security Guard" or "CCTV Camera"

            // For Services
            $table->integer('quantity')->default(1); // Number of guards OR Number of Items
            $table->decimal('hours', 8, 2)->nullable(); // Relevant if it's a service (hours/shift or total hours)

            // Pricing
            $table->decimal('unit_price', 10, 2); // Hourly Rate or Item Price
            $table->decimal('total_price', 10, 2); // (Qty * Hours * Rate) OR (Qty * Price)

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotation_items');
    }
};
