<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->string('start_evidence_path')->nullable()->after('actual_start_at');
            $table->string('end_evidence_path')->nullable()->after('actual_end_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->dropColumn(['start_evidence_path', 'end_evidence_path']);
        });
    }
};
