<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employee_site_bans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->foreignId('site_id')->constrained()->onDelete('cascade');
            $table->text('reason')->nullable();
            $table->timestamp('banned_at')->useCurrent();
            $table->timestamps();

            $table->unique(['employee_id', 'site_id']); // One active ban per employee-site (though table could store history if soft deletes used, sticking to simple status)
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_site_bans');
    }
};
