<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->timestamp('cancellation_requested_at')->nullable();
            $table->text('cancellation_reason')->nullable();
            $table->string('cancellation_status')->nullable()->default(null); // 'pending', 'rejected' ('approved' implies row deletion usually, or kept for history?)
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->dropColumn(['cancellation_requested_at', 'cancellation_reason', 'cancellation_status']);
        });
    }
};
