<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->foreignId('default_wage_type_id')->nullable()->constrained('wage_types')->nullOnDelete();
        });

        Schema::create('company_job_role_visibility', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->foreignId('job_role_id')->constrained()->onDelete('cascade');
            $table->integer('visibility_minutes')->default(10); // Minutes before start time
            $table->timestamps();

            $table->unique(['company_id', 'job_role_id'], 'co_role_vis_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('company_job_role_visibility');
        Schema::table('companies', function (Blueprint $table) {
            $table->dropForeign(['default_wage_type_id']);
            $table->dropColumn('default_wage_type_id');
        });
    }
};
