<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->dropColumn(['overtime_threshold', 'overtime_rate']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->decimal('overtime_threshold', 8, 2)->nullable();
            $table->decimal('overtime_rate', 10, 2)->nullable();
        });
    }
};
