<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->decimal('wage_rate', 10, 2)->nullable();
            $table->decimal('gas_rate', 10, 2)->nullable();
            // Store selected wage types as JSON for this employee in this schedule
            $table->json('wage_types')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('employee_schedule', function (Blueprint $table) {
            $table->dropColumn(['wage_rate', 'gas_rate', 'wage_types']);
        });
    }
};
