<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedule_wage_type', function (Blueprint $table) {
            $table->id();
            $table->foreignId('schedule_id')->constrained()->onDelete('cascade');
            $table->foreignId('wage_type_id')->constrained()->onDelete('cascade');
            $table->decimal('rate', 10, 2);
            $table->timestamps();
        });

        // Add a migration to drop old columns from schedules if you want, 
        // but for safety in this session I will just add these.
        // Actually, I should modify schedules table to make wage_type_id and wage_rate nullable or remove them.
        Schema::table('schedules', function (Blueprint $table) {
            $table->dropForeign(['wage_type_id']);
            $table->dropColumn(['wage_type_id', 'wage_rate']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('schedules', function (Blueprint $table) {
            $table->foreignId('wage_type_id')->nullable()->constrained()->nullOnDelete();
            $table->decimal('wage_rate', 10, 2)->nullable();
        });
        Schema::dropIfExists('schedule_wage_type');
    }
};
