<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('schedules', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->string('duty_number')->unique();
            $table->date('schedule_date');
            $table->foreignId('site_id')->constrained()->onDelete('cascade');
            $table->decimal('site_rate', 10, 2);
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->string('time_zone')->nullable();
            $table->string('gas')->nullable(); // Guard Attendance Status?
            $table->dateTime('from_datetime');
            $table->dateTime('to_datetime');
            $table->foreignId('wage_type_id')->nullable()->constrained()->nullOnDelete();
            $table->decimal('wage_rate', 10, 2);
            $table->string('customer_reference')->nullable();
            $table->text('comments')->nullable();
            $table->string('status')->default('upcoming'); // upcoming, today, completed, missed, archived
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('schedules');
    }
};
