<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sites', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');

            // Company Information
            $table->string('account_type'); // Regular Client, Multi-Site client
            $table->string('name');
            $table->decimal('rate', 10, 2);
            $table->string('site_id')->unique();
            $table->string('language')->nullable();
            $table->string('logo')->nullable();

            // Contact Information
            $table->string('contact_first_name')->nullable();
            $table->string('contact_last_name')->nullable();
            $table->string('contact_phone_main')->nullable();
            $table->string('contact_phone_other')->nullable();
            $table->string('account_representative')->nullable();
            $table->string('sales_representative')->nullable();
            $table->string('fax')->nullable();
            $table->string('contact_email')->nullable();

            // Address Information
            $table->string('address_line_1');
            $table->string('address_line_2')->nullable();
            $table->foreignId('country_id')->constrained();
            $table->foreignId('state_id')->constrained();
            $table->string('city');
            $table->string('zip_code');
            $table->string('latitude');
            $table->string('longitude');
            $table->string('tags')->nullable();
            $table->string('website')->nullable();

            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sites');
    }
};
