<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('id_settings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');

            // Emp ID
            $table->string('emp_prefix')->nullable();
            $table->integer('emp_next_number')->default(1);

            // Site ID
            $table->string('site_prefix')->nullable();
            $table->integer('site_next_number')->default(1);

            // Route ID
            $table->string('route_prefix')->nullable();
            $table->integer('route_next_number')->default(1);

            // Duty ID
            $table->string('duty_prefix')->nullable();
            $table->integer('duty_next_number')->default(1);

            // Incident ID
            $table->string('incident_prefix')->nullable();
            $table->integer('incident_next_number')->default(1);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('id_settings');
    }
};
