<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('employees', function (Blueprint $table) {
            $table->id();
            $table->foreignId('company_id')->constrained()->onDelete('cascade');
            $table->string('employee_id')->unique();
            $table->string('first_name');
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('gender');
            $table->string('email')->unique();
            $table->date('dob')->nullable();
            $table->string('marital_status')->nullable();

            // Job & Location
            $table->foreignId('zone_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('job_role_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('department_id')->nullable()->constrained()->nullOnDelete();

            // Permanent Address
            $table->string('phone_number');
            $table->string('emergency_number')->nullable();
            $table->string('permanent_address_line_1')->nullable();
            $table->string('permanent_address_line_2')->nullable();
            $table->string('permanent_city')->nullable();
            $table->foreignId('permanent_state_id')->nullable()->constrained('states')->nullOnDelete();
            $table->foreignId('permanent_country_id')->nullable()->constrained('countries')->nullOnDelete();
            $table->string('permanent_zip_code')->nullable();

            // Corresponding Address
            $table->string('corresponding_address_line_1')->nullable();
            $table->string('corresponding_address_line_2')->nullable();
            $table->string('corresponding_city')->nullable();
            $table->foreignId('corresponding_state_id')->nullable()->constrained('states')->nullOnDelete();
            $table->foreignId('corresponding_country_id')->nullable()->constrained('countries')->nullOnDelete();
            $table->string('corresponding_zip_code')->nullable();

            // Licence
            $table->foreignId('licence_issuing_province_id')->nullable()->constrained('states')->nullOnDelete();
            $table->string('license_number')->nullable();
            $table->date('license_expiry')->nullable();
            $table->string('file_license')->nullable(); // Path
            $table->string('file_contract')->nullable(); // Path

            // Other
            $table->string('reporting_manager')->nullable();
            $table->string('sin_number')->nullable();
            $table->string('file_direct_deposit')->nullable(); // Path
            $table->string('profile_picture')->nullable(); // Path
            $table->text('additional_remarks')->nullable();
            $table->string('tags')->nullable();
            $table->string('fax')->nullable();
            $table->date('employment_date')->nullable();
            $table->date('birthday')->nullable();
            $table->date('terminated_date')->nullable();

            $table->boolean('active')->default(true);
            $table->timestamps();
        });

        Schema::create('employee_experiences', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->string('company_name')->nullable();
            $table->string('proof_document')->nullable(); // Path
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->string('reason_for_leaving')->nullable();
            $table->timestamps();
        });

        Schema::create('employee_identifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->string('type')->nullable(); // e.g. Driving License, Security License
            $table->string('identification_number')->nullable();
            $table->date('expiry_date')->nullable();
            $table->string('file_path')->nullable();
            $table->timestamps();
        });

        Schema::create('employee_wage_type', function (Blueprint $table) {
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->foreignId('wage_type_id')->constrained()->onDelete('cascade');
            $table->decimal('rate', 10, 2)->nullable();
            $table->primary(['employee_id', 'wage_type_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('employee_wage_type');
        Schema::dropIfExists('employee_identifications');
        Schema::dropIfExists('employee_experiences');
        Schema::dropIfExists('employees');
    }
};
