<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('companies', function (Blueprint $table) {
            $table->id();
            $table->foreignId('time_zone_id')->constrained('time_zones')->onDelete('cascade');
            $table->string('name');
            $table->string('tagline')->nullable();
            $table->string('contact_person');
            $table->string('mobile_number');
            $table->string('email');
            $table->string('website')->nullable();
            $table->string('service_tax_number')->nullable();
            $table->string('hst')->nullable();
            $table->string('cst_no')->nullable();
            $table->string('cin_no')->nullable();
            $table->string('logo');
            $table->text('address_1');
            $table->text('address_2')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('companies');
    }
};
