<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        \App\Models\Notification::observe(\App\Observers\NotificationObserver::class);

        // Load dynamic settings from database
        try {
            if (class_exists(\App\Models\Setting::class) && \Illuminate\Support\Facades\Schema::hasTable('settings')) {
                $settings = \App\Models\Setting::all()->pluck('value', 'key');

                // Mailgun Configuration
                if ($settings->get('mailgun_domain')) {
                    config([
                        'services.mailgun.domain' => $settings->get('mailgun_domain'),
                        'services.mailgun.secret' => $settings->get('mailgun_secret'),
                        'services.mailgun.endpoint' => $settings->get('mailgun_endpoint', 'api.mailgun.net'),
                        'mail.default' => 'mailgun'
                    ]);
                }

                // SMTP Configuration
                if ($settings->get('mail_host')) {
                    config([
                        'mail.mailers.smtp.host' => $settings->get('mail_host'),
                        'mail.mailers.smtp.port' => $settings->get('mail_port'),
                        'mail.mailers.smtp.username' => $settings->get('mail_username'),
                        'mail.mailers.smtp.password' => $settings->get('mail_password'),
                        'mail.mailers.smtp.encryption' => $settings->get('mail_encryption'),
                        'mail.default' => 'smtp'
                    ]);
                }

                // Global From Configuration
                if ($settings->get('mail_from_address')) {
                    config([
                        'mail.from.address' => $settings->get('mail_from_address'),
                        'mail.from.name' => $settings->get('mail_from_name')
                    ]);
                }
            }
        } catch (\Exception $e) {
            // Silently fail during migrations or if table is missing
        }
    }
}
