<?php

namespace App\Observers;

use App\Models\Notification;

class NotificationObserver
{
    /**
     * Handle the Notification "created" event.
     */
    public function created(Notification $notification): void
    {
        try {
            $fcmService = new \App\Services\FcmService();
            $tokens = collect();

            if ($notification->employee_id) {
                $tokens = \App\Models\FcmToken::where('employee_id', $notification->employee_id)->pluck('token');
            } elseif ($notification->user_id) {
                $tokens = \App\Models\FcmToken::where('user_id', $notification->user_id)->pluck('token');
            }

            if ($tokens->isNotEmpty()) {
                $data = ['url' => $notification->url ?? ''];

                // Deep Link Parsing for Mobile
                if ($notification->url) {
                    $urlParts = parse_url($notification->url);
                    if (isset($urlParts['query'])) {
                        parse_str($urlParts['query'], $params);

                        if (isset($params['job_id'])) {
                            $data['job_id'] = (string) $params['job_id'];
                            $data['job_type'] = $params['job_type'] ?? 'guard';
                            $data['screen'] = 'job_notes'; // Direct mobile to notes screen
                            $data['path'] = 'job_notes'; // Alternative key for path
                            $data['click_action'] = 'FLUTTER_NOTIFICATION_CLICK';
                        }
                    }
                }

                $fcmService->sendMulticast(
                    $tokens,
                    $notification->title,
                    $notification->message,
                    $data
                );
            }
        } catch (\Exception $e) {
            \Illuminate\Support\Facades\Log::error('FCM Auto-Send Failed: ' . $e->getMessage());
        }
    }

    /**
     * Handle the Notification "updated" event.
     */
    public function updated(Notification $notification): void
    {
        //
    }

    /**
     * Handle the Notification "deleted" event.
     */
    public function deleted(Notification $notification): void
    {
        //
    }

    /**
     * Handle the Notification "restored" event.
     */
    public function restored(Notification $notification): void
    {
        //
    }

    /**
     * Handle the Notification "force deleted" event.
     */
    public function forceDeleted(Notification $notification): void
    {
        //
    }
}
