<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Zone extends Model
{
    protected $fillable = [
        'name',
        'details',
        'external_id',
        'preferred_language',
        'zone_template',
        'address',
        'city',
        'country_id',
        'state_id',
        'zip_code',
        'active',
    ];

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }
}
