<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TourRoute extends Model
{
    use HasFactory;

    protected $fillable = [
        'site_id',
        'description',
        'assigned_to',
        'special_instructions',
        'estimated_duration_minutes',
        'grace_period_minutes',
        'recurrence_type',
        'schedule_days',
    ];

    protected $casts = [
        'schedule_days' => 'array',
        'estimated_duration_minutes' => 'integer',
        'grace_period_minutes' => 'integer',
    ];

    /**
     * Get the site that owns the tour route.
     */
    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    /**
     * The checkpoints included in this tour route.
     */
    public function checkpoints()
    {
        return $this->belongsToMany(Checkpoint::class, 'checkpoint_tour_route')
            ->withPivot('order')
            ->withTimestamps()
            ->orderBy('checkpoint_tour_route.order');
    }

    public function schedules()
    {
        return $this->belongsToMany(Schedule::class, 'schedule_tour_route')->withTimestamps();
    }
}
