<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TemplateShift extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function template()
    {
        return $this->belongsTo(ScheduleTemplate::class, 'schedule_template_id');
    }

    public function jobRole()
    {
        return $this->belongsTo(JobRole::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }
}
