<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Schedule extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    public function employees()
    {
        return $this->belongsToMany(Employee::class, 'employee_schedule')
            ->withPivot('wage_types', 'wage_rate', 'bill_rate', 'gas_rate', 'actual_start_at', 'actual_end_at', 'start_lat', 'start_lng', 'end_lat', 'end_lng', 'checkin_images', 'checkout_images', 'cancellation_reason', 'cancellation_requested_at', 'cancellation_status')
            ->withTimestamps();
    }

    /*
    public function wageTypes()
    {
        // Many-to-many through employees pivot technically, but usually we just access via employees pivot
        // If we want unique wage types used in this schedule:
        return $this->belongsToMany(WageType::class, 'employee_schedule', 'schedule_id', 'wage_type_id');
    }
    */

    public function locationLogs()
    {
        return $this->hasMany(JobLocationLog::class);
    }

    public function incidents()
    {
        return $this->hasMany(Incident::class);
    }

    public function tourRoutes()
    {
        return $this->belongsToMany(TourRoute::class, 'schedule_tour_route');
    }

    /**
     * Virtual site relation for Addon views (consistency with PatrollerSchedule)
     */
    public function getVirtualSiteAttribute()
    {
        return (object) [
            'name' => $this->site->name ?? 'N/A',
            'site_id' => $this->site->site_id ?? 'N/A'
        ];
    }

    // Add Checkins relationship
    public function checkins()
    {
        return $this->hasMany(GuardCheckin::class);
    }

    public function checkpointScans()
    {
        return $this->hasMany(CheckpointScan::class);
    }

    protected $casts = [
        'schedule_date' => 'date',
        'from_datetime' => 'datetime',
        'to_datetime' => 'datetime',
        'repeat_until' => 'date',
        'active' => 'boolean',
        'is_recurring' => 'boolean',
        'exclude_days' => 'array'
    ];

    /**
     * Prepare a date for array / JSON serialization.
     *
     * @param  \DateTimeInterface  $date
     * @return string
     */
    protected function serializeDate(\DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }
}
