<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class QuotationEmailLog extends Model
{
    protected $fillable = [
        'quotation_id',
        'company_id',
        'sent_by',
        'sent_to',
        'subject',
        'sent_at',
    ];

    protected $casts = [
        'sent_at' => 'datetime',
    ];

    public function quotation()
    {
        return $this->belongsTo(Quotation::class);
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'sent_by');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
