<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Quotation extends Model
{
    use \App\Traits\LogsActivity;
    protected $fillable = [
        'company_id',
        'user_id',
        'quotation_number',
        'client_name',
        'client_email',
        'client_phone',
        'client_address',
        'issue_date',
        'valid_until',
        'subtotal',
        'tax_rate',
        'tax_amount',
        'total_amount',
        'status',
        'notes',
        'email_sent_at',
        'last_email_sent_at',
        'email_sent_count',
    ];

    protected $casts = [
        'issue_date' => 'date',
        'valid_until' => 'date',
        'email_sent_at' => 'datetime',
        'last_email_sent_at' => 'datetime',
        'subtotal' => 'decimal:2',
        'tax_rate' => 'decimal:2',
        'tax_amount' => 'decimal:2',
        'total_amount' => 'decimal:2',
    ];

    public function items()
    {
        return $this->hasMany(QuotationItem::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function emailLogs()
    {
        return $this->hasMany(QuotationEmailLog::class)->latest('sent_at');
    }
}
