<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LeadRemark extends Model
{
    protected $fillable = [
        'lead_id',
        'user_id',
        'type',
        'disposition',
        'content',
        'attachment_path',
    ];

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
