<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    use \App\Traits\LogsActivity;
    protected $fillable = [
        'company_id',
        'created_by',
        'assigned_to',
        'name',
        'company_name',
        'email',
        'phone',
        'job_title',
        'industry',
        'site_location',
        'property_type',
        'sq_footage',
        'security_needs',
        'current_provider',
        'status',
        'source',
        'contract_expiry_date',
        'incident_history',
        'next_follow_up_date',
        'next_action',
    ];

    protected $casts = [
        'contract_expiry_date' => 'date',
        'next_follow_up_date' => 'date',
        'incident_history' => 'boolean',
    ];

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function assignee()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    public function remarks()
    {
        return $this->hasMany(LeadRemark::class)->latest();
    }
}
