<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobNote extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function job()
    {
        if ($this->job_type === 'guard') {
            return $this->belongsTo(Schedule::class, 'job_id');
        }
        return $this->belongsTo(PatrollerSchedule::class, 'job_id');
    }
}
