<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class IncidentCategory extends Model
{
    use \Illuminate\Database\Eloquent\Factories\HasFactory;

    protected $fillable = [
        'incident_parent_category_id',
        'code',
        'description',
        'priority_level',
        'status',
    ];

    public function parent()
    {
        return $this->belongsTo(IncidentParentCategory::class, 'incident_parent_category_id');
    }
}
