<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Incident extends Model
{
    protected $fillable = [
        'employee_id',
        'schedule_id',
        'incident_parent_category_id',
        'incident_category_id',
        'subject',
        'description',
        'images'
    ];

    protected $casts = [
        'images' => 'array'
    ];

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function schedule()
    {
        return $this->belongsTo(Schedule::class);
    }

    public function incidentParentCategory()
    {
        return $this->belongsTo(IncidentParentCategory::class);
    }

    public function incidentCategory()
    {
        return $this->belongsTo(IncidentCategory::class);
    }
}
