<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class EmailSignature extends Model
{
    protected $fillable = [
        'company_id',
        'name',
        'content',
        'is_default'
    ];

    protected $casts = [
        'is_default' => 'boolean'
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}
