<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CompanyBranch extends Model
{
    use HasFactory;

    protected $fillable = [
        'company_id',
        'name',
        'branch_code',
        'address',
        'contact_person',
        'contact_phone',
        'contact_email',
        'active'
    ];

    public function company()
    {
        return $this->belongsTo(Company::class);
    }
}
