<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Company extends Model
{
    protected $fillable = [
        'time_zone_id',
        'name',
        'company_type',
        'tagline',
        'contact_person',
        'ceo_name',
        'ceo_email',
        'ceo_phone',
        'mobile_number',
        'email',
        'website',
        'operational_areas',
        'service_tax_number',
        'hst',
        'cst_no',
        'cin_no',
        'logo',
        'address_1',
        'address_2',
        'active',
        'default_wage_type_id'
    ];

    public function branches()
    {
        return $this->hasMany(CompanyBranch::class);
    }

    public function defaultWageType()
    {
        return $this->belongsTo(WageType::class, 'default_wage_type_id');
    }

    public function visibilitySettings()
    {
        return $this->hasMany(CompanyJobRoleVisibility::class);
    }

    public function timeZone()
    {
        return $this->belongsTo(TimeZone::class);
    }

    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    public function employees()
    {
        return $this->hasMany(Employee::class);
    }

    public function sites()
    {
        return $this->hasMany(Site::class);
    }
}
