<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CheckpointScan extends Model
{
    protected $fillable = [
        'schedule_id',
        'employee_id',
        'checkpoint_id',
        'tour_route_id',
        'scanned_at',
        'latitude',
        'longitude',
        'is_manual',
        'scan_code',
        'evidence_image',
        'employee_message',
        'additional_photos',
    ];

    protected $casts = [
        'scanned_at' => 'datetime',
        'is_manual' => 'boolean',
        'additional_photos' => 'array',
    ];

    public function schedule()
    {
        return $this->belongsTo(Schedule::class);
    }

    public function employee()
    {
        return $this->belongsTo(Employee::class);
    }

    public function checkpoint()
    {
        return $this->belongsTo(Checkpoint::class);
    }

    public function tourRoute()
    {
        return $this->belongsTo(TourRoute::class);
    }
}
