<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Checkpoint extends Model
{
    use HasFactory;

    protected $fillable = [
        'site_id',
        'name',
        'special_instructions',
        'scan_type',
        'monitoring_option',
        'scan_interval_minutes',
        'checkpoint_type',
        'checkpoint_id_code',
        'allow_manual_scan',
        'grace_period_minutes',
        'extra_scan_options',
    ];

    protected $casts = [
        'extra_scan_options' => 'array',
        'allow_manual_scan' => 'boolean',
        'scan_interval_minutes' => 'integer',
        'grace_period_minutes' => 'integer',
    ];

    /**
     * Get the site that owns the checkpoint.
     */
    public function site()
    {
        return $this->belongsTo(Site::class);
    }

    /**
     * The tour routes that include this checkpoint.
     */
    public function tourRoutes()
    {
        return $this->belongsToMany(TourRoute::class, 'checkpoint_tour_route')
            ->withPivot('order')
            ->withTimestamps()
            ->orderBy('checkpoint_tour_route.order');
    }
}
