<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'properties' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getSubjectNameAttribute()
    {
        if (!$this->subject_type)
            return 'System';
        return class_basename($this->subject_type) . " #" . $this->subject_id;
    }
}
